"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSources = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_alert_source_links = require("../../../../common/custom_threshold_rule/helpers/get_alert_source_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSources = alert => {
  var _alert$fields$ALERT_G;
  const groupsFromGroupFields = (_alert$fields$ALERT_G = alert.fields[_ruleDataUtils.ALERT_GROUP_FIELD]) === null || _alert$fields$ALERT_G === void 0 ? void 0 : _alert$fields$ALERT_G.map((field, index) => {
    const values = alert.fields[_ruleDataUtils.ALERT_GROUP_VALUE];
    if (values !== null && values !== void 0 && values.length && values[index]) {
      return {
        field,
        value: values[index]
      };
    }
  });
  if (groupsFromGroupFields !== null && groupsFromGroupFields !== void 0 && groupsFromGroupFields.length) return groupsFromGroupFields;

  // Not all rules has group.fields, in that case we search in the alert fields.
  const matchedSources = [];
  const ALL_SOURCES = [..._get_alert_source_links.infraSources, ..._get_alert_source_links.apmSources];
  const alertFields = alert.fields;
  ALL_SOURCES.forEach(source => {
    Object.keys(alertFields).forEach(field => {
      if (source === field) {
        const fieldValue = alertFields[field];
        matchedSources.push({
          field: source,
          value: Array.isArray(fieldValue) ? fieldValue[0] : fieldValue
        });
      }
    });
  });
  return matchedSources;
};
exports.getSources = getSources;