"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getViewInAppUrl = void 0;
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
var _get_group = require("./helpers/get_group");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getViewInAppUrl = ({
  dataViewId,
  endedAt,
  groups,
  logsExplorerLocator,
  metrics = [],
  searchConfiguration,
  startedAt = new Date().toISOString()
}) => {
  var _searchConfiguration$;
  if (!logsExplorerLocator) return '';
  const dataset = (_searchConfiguration$ = searchConfiguration === null || searchConfiguration === void 0 ? void 0 : searchConfiguration.index.title) !== null && _searchConfiguration$ !== void 0 ? _searchConfiguration$ : dataViewId;
  const searchConfigurationQuery = searchConfiguration === null || searchConfiguration === void 0 ? void 0 : searchConfiguration.query.query;
  const searchConfigurationFilters = (searchConfiguration === null || searchConfiguration === void 0 ? void 0 : searchConfiguration.filter) || [];
  const groupFilters = (0, _get_group.getGroupFilters)(groups);
  const timeRange = (0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(startedAt, endedAt);
  timeRange.to = endedAt ? timeRange.to : 'now';
  const query = {
    query: '',
    language: 'kuery'
  };
  const isOneCountConditionWithFilter = metrics.length === 1 && metrics[0].aggType === 'count' && metrics[0].filter;
  if (searchConfigurationQuery && isOneCountConditionWithFilter) {
    query.query = `${searchConfigurationQuery} and ${metrics[0].filter}`;
  } else if (isOneCountConditionWithFilter) {
    query.query = metrics[0].filter;
  } else if (searchConfigurationQuery) {
    query.query = searchConfigurationQuery;
  }
  return logsExplorerLocator === null || logsExplorerLocator === void 0 ? void 0 : logsExplorerLocator.getRedirectUrl({
    dataset,
    timeRange,
    query,
    filters: [...searchConfigurationFilters, ...groupFilters]
  });
};
exports.getViewInAppUrl = getViewInAppUrl;