"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flowRouteRepository = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var t = _interopRequireWildcard(require("io-ts"));
var _state = require("../../lib/state");
var _create_observability_onboarding_server_route = require("../create_observability_onboarding_server_route");
var _get_has_logs = require("./get_has_logs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateOnboardingFlowRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'PUT /internal/observability_onboarding/flow/{onboardingId}',
  options: {
    tags: []
  },
  params: t.type({
    path: t.type({
      onboardingId: t.string
    }),
    body: t.partial({
      state: t.record(t.string, t.unknown)
    })
  }),
  async handler(resources) {
    const {
      params: {
        path: {
          onboardingId
        },
        body: {
          state
        }
      },
      core,
      request
    } = resources;
    const coreStart = await core.start();
    const savedObjectsClient = coreStart.savedObjects.getScopedClient(request);
    const {
      id
    } = await (0, _state.saveObservabilityOnboardingFlow)({
      savedObjectsClient,
      savedObjectId: onboardingId,
      observabilityOnboardingState: {
        type: 'logFiles',
        state,
        progress: {}
      }
    });
    return {
      onboardingId: id
    };
  }
});
const stepProgressUpdateRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'POST /internal/observability_onboarding/flow/{id}/step/{name}',
  options: {
    tags: []
  },
  params: t.type({
    path: t.type({
      id: t.string,
      name: t.string
    }),
    body: t.intersection([t.type({
      status: t.string
    }), t.partial({
      message: t.string
    }), t.partial({
      payload: t.record(t.string, t.unknown)
    })])
  }),
  async handler(resources) {
    const {
      params: {
        path: {
          id,
          name
        },
        body: {
          status,
          message,
          payload
        }
      },
      core
    } = resources;
    const coreStart = await core.start();
    const savedObjectsClient = coreStart.savedObjects.createInternalRepository();
    const savedObservabilityOnboardingState = await (0, _state.getObservabilityOnboardingFlow)({
      savedObjectsClient,
      savedObjectId: id
    });
    if (!savedObservabilityOnboardingState) {
      throw _boom.default.notFound('Unable to report setup progress - onboarding session not found.');
    }
    const {
      id: savedObjectId,
      updatedAt,
      ...observabilityOnboardingState
    } = savedObservabilityOnboardingState;
    await (0, _state.saveObservabilityOnboardingFlow)({
      savedObjectsClient,
      savedObjectId,
      observabilityOnboardingState: {
        ...observabilityOnboardingState,
        progress: {
          ...observabilityOnboardingState.progress,
          [name]: {
            status,
            message,
            payload: payload
          }
        }
      }
    });
    return {
      name,
      status,
      message,
      payload
    };
  }
});
const getProgressRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'GET /internal/observability_onboarding/flow/{onboardingId}/progress',
  options: {
    tags: []
  },
  params: t.type({
    path: t.type({
      onboardingId: t.string
    })
  }),
  async handler(resources) {
    var _progress$eaStatus;
    const {
      params: {
        path: {
          onboardingId
        }
      },
      core,
      request
    } = resources;
    const coreStart = await core.start();
    const savedObjectsClient = coreStart.savedObjects.getScopedClient(request);
    const savedObservabilityOnboardingState = await (0, _state.getObservabilityOnboardingFlow)({
      savedObjectsClient,
      savedObjectId: onboardingId
    });
    if (!savedObservabilityOnboardingState) {
      throw _boom.default.notFound('Unable to report setup progress - onboarding session not found.');
    }
    const progress = {
      ...(savedObservabilityOnboardingState === null || savedObservabilityOnboardingState === void 0 ? void 0 : savedObservabilityOnboardingState.progress)
    };
    const esClient = coreStart.elasticsearch.client.asScoped(request).asCurrentUser;
    const type = savedObservabilityOnboardingState.type;
    if (((_progress$eaStatus = progress['ea-status']) === null || _progress$eaStatus === void 0 ? void 0 : _progress$eaStatus.status) === 'complete') {
      try {
        var _progress$eaStatus2;
        const hasLogs = await (0, _get_has_logs.getHasLogs)({
          type,
          state: savedObservabilityOnboardingState.state,
          esClient,
          payload: (_progress$eaStatus2 = progress['ea-status']) === null || _progress$eaStatus2 === void 0 ? void 0 : _progress$eaStatus2.payload
        });
        if (hasLogs) {
          progress['logs-ingest'] = {
            status: 'complete'
          };
        } else {
          progress['logs-ingest'] = {
            status: 'loading'
          };
        }
      } catch (error) {
        progress['logs-ingest'] = {
          status: 'warning',
          message: error.message
        };
      }
    } else {
      progress['logs-ingest'] = {
        status: 'incomplete'
      };
    }
    return {
      progress
    };
  }
});
const flowRouteRepository = exports.flowRouteRepository = {
  ...updateOnboardingFlowRoute,
  ...stepProgressUpdateRoute,
  ...getProgressRoute
};