"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _routes = require("./routes");
var _register_routes = require("./routes/register_routes");
var _observability_onboarding_status = require("./saved_objects/observability_onboarding_status");
var _es_legacy_config_service = require("./services/es_legacy_config_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityOnboardingPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "esLegacyConfigService", new _es_legacy_config_service.EsLegacyConfigService());
    this.initContext = initContext;
    this.initContext = initContext;
    this.logger = this.initContext.logger.get();
  }
  setup(core, plugins) {
    this.logger.debug('observability_onboarding: Setup');
    this.esLegacyConfigService.setup(core.elasticsearch.legacy.config$);
    core.savedObjects.registerType(_observability_onboarding_status.observabilityOnboardingFlow);
    const resourcePlugins = (0, _lodash.mapValues)(plugins, (value, key) => {
      return {
        setup: value,
        start: () => core.getStartServices().then(services => {
          const [, pluginsStartContracts] = services;
          return pluginsStartContracts[key];
        })
      };
    });
    const config = this.initContext.config.get();
    (0, _register_routes.registerRoutes)({
      core,
      logger: this.logger,
      repository: (0, _routes.getObservabilityOnboardingServerRouteRepository)(),
      plugins: resourcePlugins,
      config,
      kibanaVersion: this.initContext.env.packageInfo.version,
      services: {
        esLegacyConfigService: this.esLegacyConfigService
      }
    });
    return {};
  }
  start(core) {
    this.logger.debug('observability_onboarding: Started');
    return {};
  }
  stop() {
    this.esLegacyConfigService.stop();
  }
}
exports.ObservabilityOnboardingPlugin = ObservabilityOnboardingPlugin;