"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLogs = CustomLogs;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _public2 = require("@kbn/kibana-react-plugin/public");
var _app = require("../../application/app");
var _custom_logs = require("../../components/app/custom_logs");
var _filmstrip_transition = require("../../components/shared/filmstrip_transition");
var _header_action_menu = require("../../components/app/header_action_menu");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CustomLogs({
  children
}) {
  (0, _public.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability_onboarding.breadcrumbs.customLogs', {
      defaultMessage: 'Stream log files'
    })
  }], _app.breadcrumbsApp);
  return /*#__PURE__*/_react.default.createElement(AnimatedTransitionsWizard, null, children);
}
const TRANSITION_DURATION = 180;
function AnimatedTransitionsWizard({
  children
}) {
  const [transition, setTransition] = (0, _react.useState)('ready');
  const [title, setTitle] = (0, _react.useState)();
  const TransitionComponent = (0, _react.useRef)(() => null);
  const {
    services: {
      config
    }
  } = (0, _public2.useKibana)();
  const isServerless = config.serverless.enabled;
  function onChangeStep({
    direction,
    stepTitle,
    StepComponent
  }) {
    setTransition(direction);
    setTitle(stepTitle);
    TransitionComponent.current = StepComponent;
    setTimeout(() => {
      setTransition('ready');
    }, TRANSITION_DURATION + 10);
  }
  return /*#__PURE__*/_react.default.createElement(_custom_logs.Provider, {
    transitionDuration: TRANSITION_DURATION,
    onChangeStep: onChangeStep
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    "data-test-subj": "obltOnboardingStreamLogFilePageHeader"
  }, /*#__PURE__*/_react.default.createElement("h1", null, title ? title : _i18n.i18n.translate('xpack.observability_onboarding.title.collectCustomLogs', {
    defaultMessage: 'Stream log files to Elastic'
  })))), isServerless && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      position: 'absolute',
      right: 10
    }
  }, /*#__PURE__*/_react.default.createElement(_header_action_menu.ObservabilityOnboardingHeaderActionMenu, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      width: '50%'
    }
  }, /*#__PURE__*/_react.default.createElement(_filmstrip_transition.FilmstripTransition, {
    duration: TRANSITION_DURATION,
    transition: transition
  }, /*#__PURE__*/_react.default.createElement(_filmstrip_transition.FilmstripFrame, {
    position: transition === 'ready' ? 'center' : transition === 'back' ? 'left' : 'right'
  }, children)))));
}