"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWizard = exports.systemLogsRoutes = exports.Provider = void 0;
var _i18n = require("@kbn/i18n");
var _create_wizard_context = require("../../../context/create_wizard_context");
var _install_elastic_agent = require("./install_elastic_agent");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  elasticAgentPlatform: 'linux-tar',
  autoDownloadConfig: false,
  apiKeyEncoded: '',
  onboardingId: ''
};
const steps = {
  installElasticAgent: {
    component: _install_elastic_agent.InstallElasticAgent,
    title: _i18n.i18n.translate('xpack.observability_onboarding.systemLogs.installShipper.title', {
      defaultMessage: 'Install shipper to collect system logs'
    })
  }
};
const {
  Provider,
  useWizard,
  routes: systemLogsRoutes
} = (0, _create_wizard_context.createWizardContext)({
  initialState,
  initialStep: 'installElasticAgent',
  steps,
  basePath: '/systemLogs'
});
exports.systemLogsRoutes = systemLogsRoutes;
exports.useWizard = useWizard;
exports.Provider = Provider;