"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceSpecialChars = exports.getFilename = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilename = path => {
  if (!path) {
    return '';
  }
  const filenameWithExt = path.replace(/^.*[\\\/](?!\d*$)/g, '');
  const filenameParts = filenameWithExt.split('.');
  return replaceSpecialChars(filenameParts[0]);
};
exports.getFilename = getFilename;
const replaceSpecialChars = filename => filename.replaceAll(/[^a-zA-Z0-9_]/g, '_');
exports.replaceSpecialChars = replaceSpecialChars;