"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationCardList = useIntegrationCardList;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUICKSTART_FLOWS = ['kubernetes', 'nginx', 'system-logs-generated'];
const toCustomCard = card => ({
  ...card,
  isQuickstart: QUICKSTART_FLOWS.includes(card.name)
});
function extractFeaturedCards(filteredCards, featuredCardNames) {
  const featuredCards = {};
  filteredCards.forEach(card => {
    if (featuredCardNames !== null && featuredCardNames !== void 0 && featuredCardNames.includes(card.name)) {
      featuredCards[card.name] = card;
    }
  });
  return featuredCards;
}
function useIntegrationCardList(filteredCards, selectedCategory = 'observability', customCards) {
  const featuredCards = (0, _react.useMemo)(() => {
    if (!customCards) return {};
    return extractFeaturedCards(filteredCards, customCards.filter(c => c.type === 'featured').map(c => c.name));
  }, [filteredCards, customCards]);
  if (customCards && customCards.length > 0) {
    return customCards.map(c => {
      if (c.type === 'featured') {
        return !!featuredCards[c.name] ? toCustomCard(featuredCards[c.name]) : null;
      }
      return toCustomCard(c);
    }).filter(c => c);
  }
  return filteredCards.filter(card => card.categories.includes(selectedCategory)).map(toCustomCard);
}