"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingFlowPackageList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _useAsyncRetry = _interopRequireDefault(require("react-use/lib/useAsyncRetry"));
var _lazy = require("./lazy");
var _use_integration_card_list = require("./use_integration_card_list");
var _use_custom_margin = require("../shared/use_custom_margin");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Loading = () => /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
  isLoading: true,
  lines: 10
});
const PackageListGridWrapper = ({
  selectedCategory = 'observability',
  useAvailablePackages,
  showSearchBar = false,
  searchBarRef,
  searchQuery,
  setSearchQuery,
  customCards
}) => {
  const [isInitialHidden, setIsInitialHidden] = (0, _react2.useState)(showSearchBar);
  const customMargin = (0, _use_custom_margin.useCustomMargin)();
  const {
    filteredCards,
    isLoading
  } = useAvailablePackages({
    prereleaseIntegrationsEnabled: false
  });
  const list = (0, _use_integration_card_list.useIntegrationCardList)(filteredCards, selectedCategory, customCards);
  _react2.default.useEffect(() => {
    if (isInitialHidden && searchQuery) {
      setIsInitialHidden(false);
    }
  }, [searchQuery, isInitialHidden]);
  if (!isInitialHidden && isLoading) return /*#__PURE__*/_react2.default.createElement(Loading, null);
  const showPackageList = showSearchBar && !isInitialHidden || showSearchBar === false;
  return /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
    fallback: /*#__PURE__*/_react2.default.createElement(Loading, null)
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: customMargin
  }, showSearchBar && /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
              max-width: 600px;
            `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSearchBar, {
    box: {
      incremental: true,
      inputRef: ref => {
        searchBarRef.current = ref;
      }
    },
    onChange: arg => {
      if (setSearchQuery) {
        setSearchQuery(arg.queryText);
      }
      setIsInitialHidden(false);
    },
    query: searchQuery
  })), showPackageList && /*#__PURE__*/_react2.default.createElement(_lazy.PackageList, {
    list: list,
    searchTerm: searchQuery !== null && searchQuery !== void 0 ? searchQuery : '',
    showControls: false,
    showSearchTools: false
    // we either don't need these properties (yet) or handle them upstream, but
    // they are marked as required in the original API.
    ,
    selectedCategory: selectedCategory,
    setSearchTerm: () => {},
    setCategory: () => {},
    categories: [],
    setUrlandReplaceHistory: () => {},
    setUrlandPushHistory: () => {}
  })));
};
const WithAvailablePackages = exports.OnboardingFlowPackageList = /*#__PURE__*/_react2.default.forwardRef((props, searchBarRef) => {
  const ref = (0, _react2.useRef)(null);
  const {
    error: errorLoading,
    retry: retryAsyncLoad,
    loading: asyncLoading
  } = (0, _useAsyncRetry.default)(async () => {
    ref.current = await (0, _lazy.fetchAvailablePackagesHook)();
  });
  if (errorLoading) return /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.asyncLoadFailureCallout.title', {
      defaultMessage: 'Loading failure'
    }),
    color: "warning",
    iconType: "cross",
    size: "m"
  }, /*#__PURE__*/_react2.default.createElement("p", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.asyncLoadFailureCallout.copy",
    defaultMessage: "Some required elements failed to load."
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    color: "warning",
    "data-test-subj": "xpack.observability_onboarding.asyncLoadFailureCallout.button",
    onClick: () => {
      if (!asyncLoading) retryAsyncLoad();
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.asyncLoadFailureCallout.buttonContent",
    defaultMessage: "Retry"
  })));
  if (asyncLoading || ref.current === null) return /*#__PURE__*/_react2.default.createElement(Loading, null);
  return /*#__PURE__*/_react2.default.createElement(PackageListGridWrapper, (0, _extends2.default)({}, props, {
    useAvailablePackages: ref.current,
    searchBarRef: searchBarRef
  }));
});