"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingFlowForm = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _packages_list = require("../packages_list");
var _use_custom_margin = require("../shared/use_custom_margin");
var _use_custom_cards_for_category = require("./use_custom_cards_for_category");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnboardingFlowForm = () => {
  const options = [{
    id: 'logs',
    label: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.euiCheckableCard.collectAndAnalyzeMyLabel', {
      defaultMessage: 'Collect and analyze my logs'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.onboardingFlowForm.detectPatternsAndOutliersLabel', {
      defaultMessage: 'Detect patterns, troubleshoot in real time, gain insights from logs.'
    })
  }, {
    id: 'apm',
    label: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.euiCheckableCard.monitorMyApplicationPerformanceLabel', {
      defaultMessage: 'Monitor my application performance'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.onboardingFlowForm.captureAndAnalyzeDistributedLabel', {
      defaultMessage: 'Collect distributed traces and catch application performance problems.'
    })
  }, {
    id: 'infra',
    label: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.euiCheckableCard.monitorMyInfrastructureLabel', {
      defaultMessage: 'Monitor my infrastructure'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.onboardingFlowForm.builtOnPowerfulElasticsearchLabel', {
      defaultMessage: 'Stream infrastructure metrics and accelerate root cause detection by breaking down silos.'
    })
  }];
  const customMargin = (0, _use_custom_margin.useCustomMargin)();
  const radioGroupId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'onboardingCategory'
  });
  const [searchParams, setSearchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const packageListSearchBarRef = _react.default.useRef(null);
  const [integrationSearch, setIntegrationSearch] = (0, _react.useState)('');
  const createCollectionCardHandler = (0, _react.useCallback)(query => () => {
    setIntegrationSearch(query);
    if (packageListSearchBarRef.current) {
      packageListSearchBarRef.current.focus();
      packageListSearchBarRef.current.scrollIntoView({
        behavior: 'auto',
        block: 'center'
      });
    }
  }, [setIntegrationSearch]);
  const customCards = (0, _use_custom_cards_for_category.useCustomCardsForCategory)(createCollectionCardHandler, searchParams.get('category'));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(TitleWithIcon, {
    iconType: "indexRollupApp",
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.strong.startCollectingYourDataLabel', {
      defaultMessage: 'Start collecting your data by selecting one of the following use cases'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: customMargin,
    gutterSize: "m",
    direction: "column"
  }, options.map(option => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: option.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: `${radioGroupId}_${option.id}`,
    name: radioGroupId,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: {
        fontWeight: 'bold'
      }
    }, option.label), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, option.description)),
    checked: option.id === searchParams.get('category'),
    onChange: () => setSearchParams({
      category: option.id
    }, {
      replace: true
    })
  })))), searchParams.get('category') && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(TitleWithIcon, {
    iconType: "savedObjectsApp",
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.whatTypeOfResourceLabel', {
      defaultMessage: 'What type of resource are you monitoring?'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), Array.isArray(customCards) && /*#__PURE__*/_react.default.createElement(_packages_list.OnboardingFlowPackageList, {
    customCards: customCards
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: customMargin,
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.experimentalOnboardingFlow.form.searchPromptText",
    defaultMessage: "Not seeing yours? Search through our 130 ways of ingesting data:"
  })), /*#__PURE__*/_react.default.createElement(_packages_list.OnboardingFlowPackageList, {
    showSearchBar: true,
    searchQuery: integrationSearch,
    setSearchQuery: setIntegrationSearch,
    ref: packageListSearchBarRef
  })));
};
exports.OnboardingFlowForm = OnboardingFlowForm;
const TitleWithIcon = ({
  title,
  iconType
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  responsive: false,
  gutterSize: "m",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
  size: "l",
  name: title,
  iconType: iconType,
  color: "subdued"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("strong", null, title))));