"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _integrations_icon = _interopRequireDefault(require("./integrations_icon.svg"));
var _demo_icon = _interopRequireDefault(require("./demo_icon.svg"));
var _docs_icon = _interopRequireDefault(require("./docs_icon.svg"));
var _forum_icon = _interopRequireDefault(require("./forum_icon.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Footer = () => {
  const sections = [{
    iconUrl: _integrations_icon.default,
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.dataSourcesFlexItemLabel', {
      defaultMessage: 'Data sources'
    }),
    description: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod'
  }, {
    iconUrl: _demo_icon.default,
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.demoEnvironmentFlexItemLabel', {
      defaultMessage: 'Demo environment'
    }),
    description: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod'
  }, {
    iconUrl: _docs_icon.default,
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.exploreForumFlexItemLabel', {
      defaultMessage: 'Explore forum'
    }),
    description: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod'
  }, {
    iconUrl: _forum_icon.default,
    title: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.browseDocumentationFlexItemLabel', {
      defaultMessage: 'Browse documentation'
    }),
    description: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, sections.map((section, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    size: "l",
    name: "",
    imageUrl: section.iconUrl,
    color: "subdued"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, section.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, section.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "observabilityOnboardingFooterLearnMoreLink",
    href: "#/navigation/link",
    external: true
  }, _i18n.i18n.translate('xpack.observability_onboarding.footer.learnMoreLinkLabel', {
    defaultMessage: 'Learn more'
  })))))));
};
exports.Footer = Footer;