"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExperimentalOnboardingFlow = ExperimentalOnboardingFlow;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _background = _interopRequireDefault(require("./header/background.svg"));
var _footer = require("./footer/footer");
var _onboarding_flow_form = require("./onboarding_flow_form/onboarding_flow_form");
var _header = require("./header/header");
var _system_logs = require("./quickstart_flows/system_logs");
var _custom_logs = require("./quickstart_flows/custom_logs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const queryClient = new _reactQuery.QueryClient();
function ExperimentalOnboardingFlow() {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDomV5Compat.useLocation)();
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    grow: false,
    color: "accent",
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "observabilityOnboardingExperimentalOnboardingFlowSystemLogsButton"
  }, (0, _public.reactRouterNavigate)(history, `/systemLogs/${location.search}`), {
    color: "accent"
  }), _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.systemLogsButtonLabel', {
    defaultMessage: 'System Logs'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "observabilityOnboardingExperimentalOnboardingFlowCustomLogsButton"
  }, (0, _public.reactRouterNavigate)(history, `/customLogs/${location.search}`), {
    color: "accent"
  }), _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customLogsButtonLabel', {
    defaultMessage: 'Custom Logs'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: "xl",
    css: (0, _react2.css)`
          & > div {
            background-image: url(${_background.default});
            background-position: right center;
            background-repeat: no-repeat;
          }
        `,
    grow: false,
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_header.Header, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: "xl",
    color: "subdued",
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/systemLogs"
  }, /*#__PURE__*/_react.default.createElement(BackButton, null), /*#__PURE__*/_react.default.createElement(_system_logs.SystemLogsPanel, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/customLogs"
  }, /*#__PURE__*/_react.default.createElement(BackButton, null), /*#__PURE__*/_react.default.createElement(_custom_logs.CustomLogsPanel, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_onboarding_flow_form.OnboardingFlowForm, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: "xl",
    grow: false,
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_footer.Footer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })));
}
const BackButton = () => {
  const navigate = (0, _reactRouterDomV5Compat.useNavigate)();
  const location = (0, _reactRouterDomV5Compat.useLocation)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "observabilityOnboardingExperimentalOnboardingFlowBackToSelectionButton",
    iconType: "arrowLeft",
    flush: "left",
    onClick: () => navigate(`../${location.search}`)
  }, _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.button.backToSelectionLabel', {
    defaultMessage: 'Back to selection'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};