"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.subscribeToDatasetQualityState = exports.openDatasetFlyout = exports.createController = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createController = ({
  createDatasetQualityController
}) => (context, event) => send => {
  createDatasetQualityController({
    initialState: context.initialDatasetQualityState
  }).then(controller => {
    send({
      type: 'CONTROLLER_CREATED',
      controller
    });
  });
};
exports.createController = createController;
const subscribeToDatasetQualityState = (context, _event) => send => {
  if (!('controller' in context)) {
    throw new Error('Failed to subscribe to controller: no controller in context');
  }
  const {
    controller
  } = context;
  const subscription = controller.state$.subscribe({
    next: state => {
      send({
        type: 'DATASET_QUALITY_STATE_CHANGED',
        state
      });
    }
  });
  controller.service.start();
  return () => {
    subscription.unsubscribe();
    controller.service.stop();
  };
};
exports.subscribeToDatasetQualityState = subscribeToDatasetQualityState;
const openDatasetFlyout = context => {
  if (!('controller' in context)) {
    throw new Error('Failed to subscribe to controller: no controller in context');
  }
  const {
    controller,
    initialDatasetQualityState: {
      flyout
    }
  } = context;
  if (flyout !== null && flyout !== void 0 && flyout.dataset) {
    controller.service.send({
      type: 'OPEN_FLYOUT',
      dataset: flyout.dataset
    });
  }
};
exports.openDatasetFlyout = openDatasetFlyout;