"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityLogsExplorerMainRoute = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = require("@xstate/react");
var _react2 = _interopRequireWildcard(require("react"));
var _logs_explorer_top_nav_menu = require("../../components/logs_explorer_top_nav_menu");
var _page_template = require("../../components/page_template");
var _logs_explorer_customizations = require("../../logs_explorer_customizations");
var _src = require("../../state_machines/observability_logs_explorer/src");
var _lazy_component = require("../../state_machines/origin_interpreter/src/lazy_component");
var _breadcrumbs = require("../../utils/breadcrumbs");
var _kbn_url_state_context = require("../../utils/kbn_url_state_context");
var _use_kibana = require("../../utils/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObservabilityLogsExplorerMainRoute = () => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    logsExplorer,
    serverless,
    chrome,
    notifications,
    appParams
  } = services;
  const {
    history
  } = appParams;
  (0, _breadcrumbs.useBreadcrumbs)(_breadcrumbs.noBreadcrumbs, chrome, serverless);
  const urlStateStorageContainer = (0, _kbn_url_state_context.useKbnUrlStateStorageFromRouterContext)();
  const createLogsExplorerController = (0, _react2.useMemo)(() => (0, _logs_explorer_customizations.createLogsExplorerControllerWithCustomizations)(logsExplorer.createLogsExplorerController, services), [logsExplorer.createLogsExplorerController, services]);
  return /*#__PURE__*/_react2.default.createElement(_src.ObservabilityLogsExplorerPageStateProvider, {
    createLogsExplorerController: createLogsExplorerController,
    toasts: notifications.toasts,
    urlStateStorageContainer: urlStateStorageContainer,
    timeFilterService: services.data.query.timefilter.timefilter
  }, /*#__PURE__*/_react2.default.createElement(_logs_explorer_top_nav_menu.LogsExplorerTopNavMenu, null), /*#__PURE__*/_react2.default.createElement(_lazy_component.LazyOriginInterpreter, {
    history: history,
    toasts: notifications.toasts
  }), /*#__PURE__*/_react2.default.createElement(ConnectedContent, null));
};
exports.ObservabilityLogsExplorerMainRoute = ObservabilityLogsExplorerMainRoute;
const ConnectedContent = /*#__PURE__*/_react2.default.memo(() => {
  const {
    services: {
      appParams: {
        history
      },
      logsExplorer
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [state] = (0, _react.useActor)((0, _src.useObservabilityLogsExplorerPageStateContext)());
  if (state.matches('initialized')) {
    return /*#__PURE__*/_react2.default.createElement(InitializedContent, {
      logsExplorerController: state.context.controller,
      history: history,
      logsExplorer: logsExplorer
    });
  } else {
    return /*#__PURE__*/_react2.default.createElement(InitializingContent, null);
  }
});
const InitializingContent = /*#__PURE__*/_react2.default.memo(() => /*#__PURE__*/_react2.default.createElement(_page_template.ObservabilityLogsExplorerPageTemplate, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
  icon: /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoKibana",
    size: "xl"
  }),
  title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityLogsExplorer.InitializingTitle",
    defaultMessage: "Initializing the Logs Explorer"
  })
})));
const InitializedContent = /*#__PURE__*/_react2.default.memo(({
  history,
  logsExplorer,
  logsExplorerController
}) => {
  return /*#__PURE__*/_react2.default.createElement(_page_template.ObservabilityLogsExplorerPageTemplate, null, /*#__PURE__*/_react2.default.createElement(logsExplorer.LogsExplorer, {
    controller: logsExplorerController,
    scopedHistory: history
  }));
});