"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.constructDatasetQualityLocatorPath = void 0;
var _common = require("@kbn/kibana-utils-plugin/common");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _url_schema = require("../../url_schema");
var _deep_compact_object = require("../../utils/deep_compact_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const constructDatasetQualityLocatorPath = async params => {
  const {
    locatorParams: {
      filters
    },
    useHash
  } = params;
  const pageState = _url_schema.datasetQualityUrlSchemaV1.urlSchemaRT.encode((0, _deep_compact_object.deepCompactObject)({
    v: 1,
    filters
  }));
  const path = (0, _common.setStateToKbnUrl)(_url_schema.OBSERVABILITY_DATASET_QUALITY_URL_STATE_KEY, pageState, {
    useHash,
    storeInHashQuery: false
  }, '/dataset-quality');
  return {
    app: _deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID,
    path,
    state: {}
  };
};
exports.constructDatasetQualityLocatorPath = constructDatasetQualityLocatorPath;