"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceSystemMessage = replaceSystemMessage;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function replaceSystemMessage(systemMessage, messages) {
  return [{
    '@timestamp': new Date().toISOString(),
    message: {
      role: _common.MessageRole.System,
      content: systemMessage
    }
  }, ...messages.filter(msg => msg.message.role !== _common.MessageRole.System)];
}