"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createServerSideFunctionResponseError = createServerSideFunctionResponseError;
var _elasticsearch = require("@elastic/elasticsearch");
var _create_function_response_message = require("../../../common/utils/create_function_response_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createServerSideFunctionResponseError({
  name,
  error,
  message
}) {
  const isElasticsearchError = error instanceof _elasticsearch.errors.ElasticsearchClientError;
  const sanitizedError = JSON.parse('toJSON' in error && typeof error.toJSON === 'function' ? error.toJSON() : JSON.stringify(error));
  if (isElasticsearchError) {
    // remove meta key which is huge and noisy
    delete sanitizedError.meta;
  }
  return (0, _create_function_response_message.createFunctionResponseMessage)({
    name,
    content: {
      error: {
        ...sanitizedError,
        name: error.name,
        message: error.message,
        cause: error.cause
      },
      message: message || error.message
    },
    data: {
      stack: error.stack
    }
  });
}