"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.catchFunctionLimitExceededError = catchFunctionLimitExceededError;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _common = require("../../../common");
var _conversation_complete = require("../../../common/conversation_complete");
var _emit_with_concatenated_message = require("../../../common/utils/emit_with_concatenated_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function catchFunctionLimitExceededError() {
  return source$ => {
    const shared$ = source$.pipe((0, _rxjs.shareReplay)());
    const chunksWithoutErrors$ = shared$.pipe((0, _rxjs.catchError)(() => (0, _rxjs.of)()), (0, _rxjs.shareReplay)());
    return shared$.pipe((0, _rxjs.catchError)(error => {
      if ((0, _conversation_complete.isFunctionNotFoundError)(error)) {
        const withInjectedErrorMessage$ = chunksWithoutErrors$.pipe((0, _rxjs.filter)(msg => msg.type === _common.StreamingChatResponseEventType.ChatCompletionChunk), (0, _emit_with_concatenated_message.emitWithConcatenatedMessage)(async concatenatedMessage => {
          return {
            ...concatenatedMessage,
            message: {
              ...concatenatedMessage.message,
              content: `${concatenatedMessage.message.content}\n\n${_i18n.i18n.translate('xpack.observabilityAiAssistant.functionCallLimitExceeded', {
                defaultMessage: '\n\nNote: the Assistant tried to call a function, even though the limit was exceeded'
              })}`,
              function_call: {
                name: '',
                arguments: '',
                trigger: _common.MessageRole.Assistant
              }
            }
          };
        }));
        return withInjectedErrorMessage$;
      }
      return (0, _rxjs.throwError)(() => error);
    }));
  };
}