"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kbComponentTemplate = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const keyword = {
  type: 'keyword',
  ignore_above: 1024
};
const text = {
  type: 'text'
};
const date = {
  type: 'date'
};
const dynamic = {
  type: 'object',
  dynamic: true
};
const kbComponentTemplate = exports.kbComponentTemplate = {
  mappings: {
    dynamic: false,
    properties: {
      '@timestamp': date,
      id: keyword,
      doc_id: {
        type: 'text',
        fielddata: true
      },
      user: {
        properties: {
          id: keyword,
          name: keyword
        }
      },
      labels: dynamic,
      conversation: {
        properties: {
          id: keyword,
          title: text,
          last_updated: date
        }
      },
      namespace: keyword,
      text,
      'ml.tokens': {
        type: 'rank_features'
      },
      confidence: keyword,
      is_correction: {
        type: 'boolean'
      },
      public: {
        type: 'boolean'
      }
    }
  }
};