"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hideTokenCountEvents = hideTokenCountEvents;
var _rxjs = require("rxjs");
var _conversation_complete = require("../../../../common/conversation_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function hideTokenCountEvents(cb) {
  // `hide` can be called multiple times, so we keep track of each invocation
  const allInterceptors = [];
  const hide = () => source$ => {
    const [tokenCountEvents$, otherEvents$] = (0, _rxjs.partition)(source$, value => value.type === _conversation_complete.StreamingChatResponseEventType.TokenCount);
    allInterceptors.push(tokenCountEvents$);
    return otherEvents$;
  };

  // combine the two observables again
  return (0, _rxjs.merge)(cb(hide), ...allInterceptors);
}