"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContextFunctionRequestIfNeeded = getContextFunctionRequestIfNeeded;
var _lodash = require("lodash");
var _common = require("../../../common");
var _create_function_request_message = require("../../../common/utils/create_function_request_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getContextFunctionRequestIfNeeded(messages) {
  const indexOfLastUserMessage = (0, _lodash.findLastIndex)(messages, message => message.message.role === _common.MessageRole.User && !message.message.name);
  const hasContextSinceLastUserMessage = messages.slice(indexOfLastUserMessage).some(message => message.message.name === 'context');
  if (hasContextSinceLastUserMessage) {
    return undefined;
  }
  return (0, _create_function_request_message.createFunctionRequestMessage)({
    name: 'context',
    args: {
      queries: [],
      categories: []
    }
  });
}