"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMessagesWithSimulatedFunctionCalling = getMessagesWithSimulatedFunctionCalling;
var _constants = require("./constants");
var _get_system_message_instructions = require("./get_system_message_instructions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMessagesWithSimulatedFunctionCalling({
  messages,
  functions,
  functionCall
}) {
  var _systemMessage$messag;
  const [systemMessage, ...otherMessages] = messages;
  const instructions = (0, _get_system_message_instructions.getSystemMessageInstructions)({
    functions
  });
  systemMessage.message.content = ((_systemMessage$messag = systemMessage.message.content) !== null && _systemMessage$messag !== void 0 ? _systemMessage$messag : '') + '\n' + instructions;
  return [systemMessage, ...otherMessages].map((message, index) => {
    var _message$message$func;
    if (message.message.name) {
      const deserialized = JSON.parse(message.message.content || '{}');
      const results = {
        type: 'tool_result',
        tool: message.message.name,
        ...(message.message.content ? JSON.parse(message.message.content) : {})
      };
      if ('error' in deserialized) {
        return {
          ...message,
          message: {
            role: message.message.role,
            content: JSON.stringify({
              ...results,
              is_error: true
            })
          }
        };
      }
      return {
        ...message,
        message: {
          role: message.message.role,
          content: JSON.stringify(results)
        }
      };
    }
    let content = message.message.content || '';
    if ((_message$message$func = message.message.function_call) !== null && _message$message$func !== void 0 && _message$message$func.name) {
      content += _constants.TOOL_USE_START + '\n```json\n' + JSON.stringify({
        name: message.message.function_call.name,
        input: JSON.parse(message.message.function_call.arguments || '{}')
      }) + '\n```' + _constants.TOOL_USE_END;
    }
    if (index === messages.length - 1 && functionCall) {
      content += `
      
      Remember, use the ${functionCall} tool to answer this question.`;
    }
    return {
      ...message,
      message: {
        role: message.message.role,
        content
      }
    };
  });
}