"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processOpenAiStream = processOpenAiStream;
var _gptTokenizer = require("gpt-tokenizer");
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function processOpenAiStream({
  promptTokenCount,
  logger
}) {
  return source => {
    return new _rxjs.Observable(subscriber => {
      const id = (0, _uuid.v4)();
      let completionTokenCount = 0;
      function emitTokenCountEvent() {
        subscriber.next({
          type: _common.StreamingChatResponseEventType.TokenCount,
          tokens: {
            completion: completionTokenCount,
            prompt: promptTokenCount,
            total: completionTokenCount + promptTokenCount
          }
        });
      }
      const parsed$ = source.pipe((0, _rxjs.filter)(line => !!line && line !== '[DONE]'), (0, _rxjs.map)(line => JSON.parse(line)), (0, _rxjs.tap)(line => {
        var _firstChoice$delta$fu, _firstChoice$delta$fu2;
        if ('error' in line) {
          throw (0, _common.createInternalServerError)(line.error.message);
        }
        if ('choices' in line && line.choices.length && line.choices[0].finish_reason === 'length') {
          throw (0, _common.createTokenLimitReachedError)();
        }
        const firstChoice = (0, _lodash.first)(line.choices);
        completionTokenCount += (0, _lodash.sum)([firstChoice === null || firstChoice === void 0 ? void 0 : firstChoice.delta.content, firstChoice === null || firstChoice === void 0 ? void 0 : (_firstChoice$delta$fu = firstChoice.delta.function_call) === null || _firstChoice$delta$fu === void 0 ? void 0 : _firstChoice$delta$fu.name, firstChoice === null || firstChoice === void 0 ? void 0 : (_firstChoice$delta$fu2 = firstChoice.delta.function_call) === null || _firstChoice$delta$fu2 === void 0 ? void 0 : _firstChoice$delta$fu2.arguments].map(val => (0, _gptTokenizer.encode)(val || '').length) || 0);
      }), (0, _rxjs.filter)(line => 'object' in line && line.object === 'chat.completion.chunk'), (0, _rxjs.map)(chunk => {
        var _delta$tool_calls$0$f, _delta$tool_calls$0$f2, _delta$content;
        const delta = chunk.choices[0].delta;
        if (delta.tool_calls && delta.tool_calls.length > 1) {
          logger.warn(`More tools than 1 were called: ${JSON.stringify(delta.tool_calls)}`);
        }
        const functionCall = delta.tool_calls ? {
          name: (_delta$tool_calls$0$f = delta.tool_calls[0].function) === null || _delta$tool_calls$0$f === void 0 ? void 0 : _delta$tool_calls$0$f.name,
          arguments: (_delta$tool_calls$0$f2 = delta.tool_calls[0].function) === null || _delta$tool_calls$0$f2 === void 0 ? void 0 : _delta$tool_calls$0$f2.arguments
        } : delta.function_call;
        return {
          id,
          type: _common.StreamingChatResponseEventType.ChatCompletionChunk,
          message: {
            content: (_delta$content = delta.content) !== null && _delta$content !== void 0 ? _delta$content : '',
            function_call: functionCall
          }
        };
      }));
      parsed$.subscribe({
        next: val => {
          subscriber.next(val);
        },
        error: error => {
          emitTokenCountEvent();
          subscriber.error(error);
        },
        complete: () => {
          emitTokenCountEvent();
          subscriber.complete();
        }
      });
    });
  };
}