"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.failOnNonExistingFunctionCall = failOnNonExistingFunctionCall;
var _rxjs = require("rxjs");
var _common = require("../../../../common");
var _concatenate_chat_completion_chunks = require("../../../../common/utils/concatenate_chat_completion_chunks");
var _without_token_count_events = require("../../../../common/utils/without_token_count_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function failOnNonExistingFunctionCall({
  functions
}) {
  return source$ => {
    const shared$ = source$.pipe((0, _rxjs.shareReplay)());
    return (0, _rxjs.merge)(shared$, shared$.pipe((0, _without_token_count_events.withoutTokenCountEvents)(), (0, _concatenate_chat_completion_chunks.concatenateChatCompletionChunks)(), (0, _rxjs.last)(), (0, _rxjs.tap)(event => {
      if (event.message.function_call.name && (functions === null || functions === void 0 ? void 0 : functions.find(fn => fn.name === event.message.function_call.name)) === undefined) {
        throw (0, _common.createFunctionNotFoundError)(event.message.function_call.name);
      }
    }), (0, _rxjs.ignoreElements)()));
  };
}