"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBedrockClaudeAdapter = void 0;
var _rxjs = require("rxjs");
var _conversation_complete = require("../../../../../common/conversation_complete");
var _eventstream_serde_into_observable = require("../../../util/eventstream_serde_into_observable");
var _process_bedrock_stream = require("./process_bedrock_stream");
var _get_messages_with_simulated_function_calling = require("../simulate_function_calling/get_messages_with_simulated_function_calling");
var _parse_inline_function_calls = require("../simulate_function_calling/parse_inline_function_calls");
var _constants = require("../simulate_function_calling/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function replaceFunctionsWithTools(content) {
  return content.replaceAll(/(function)(s|[\s*\.])?(?!\scall)/g, (match, p1, p2) => {
    return `tool${p2 || ''}`;
  });
}

// Most of the work here is to re-format OpenAI-compatible functions for Claude.
// See https://github.com/anthropics/anthropic-tools/blob/main/tool_use_package/prompt_constructors.py

const createBedrockClaudeAdapter = ({
  messages,
  functions,
  functionCall,
  logger
}) => {
  const filteredFunctions = functionCall ? functions === null || functions === void 0 ? void 0 : functions.filter(fn => fn.name === functionCall) : functions;
  return {
    getSubAction: () => {
      const messagesWithSimulatedFunctionCalling = (0, _get_messages_with_simulated_function_calling.getMessagesWithSimulatedFunctionCalling)({
        messages,
        functions: filteredFunctions,
        functionCall
      });
      const formattedMessages = messagesWithSimulatedFunctionCalling.map(message => {
        var _message$message$cont;
        return {
          role: message.message.role,
          content: replaceFunctionsWithTools((_message$message$cont = message.message.content) !== null && _message$message$cont !== void 0 ? _message$message$cont : '')
        };
      });
      return {
        subAction: 'invokeStream',
        subActionParams: {
          messages: formattedMessages,
          temperature: 0,
          stopSequences: ['\n\nHuman:', _constants.TOOL_USE_END]
        }
      };
    },
    streamIntoObservable: readable => (0, _eventstream_serde_into_observable.eventstreamSerdeIntoObservable)(readable, logger).pipe((0, _rxjs.tap)(value => {
      if ('modelStreamErrorException' in value) {
        throw (0, _conversation_complete.createInternalServerError)(value.modelStreamErrorException.originalMessage);
      }
    }), (0, _rxjs.filter)(value => {
      var _value$chunk, _value$chunk$headers, _value$chunk$headers$;
      return 'chunk' in value && ((_value$chunk = value.chunk) === null || _value$chunk === void 0 ? void 0 : (_value$chunk$headers = _value$chunk.headers) === null || _value$chunk$headers === void 0 ? void 0 : (_value$chunk$headers$ = _value$chunk$headers[':event-type']) === null || _value$chunk$headers$ === void 0 ? void 0 : _value$chunk$headers$.value) === 'chunk';
    }), (0, _process_bedrock_stream.processBedrockStream)(), (0, _parse_inline_function_calls.parseInlineFunctionCalls)({
      logger
    }))
  };
};
exports.createBedrockClaudeAdapter = createBedrockClaudeAdapter;