"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.knowledgeBaseRoutes = void 0;
var _boom = require("@hapi/boom");
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
var _types = require("../../../common/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKnowledgeBaseStatus = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/kb/status',
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return await client.getKnowledgeBaseStatus();
  }
});
const setupKnowledgeBase = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/kb/setup',
  options: {
    tags: ['access:ai_assistant'],
    timeout: {
      idleSocket: 20 * 60 * 1000 // 20 minutes
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    await client.setupKnowledgeBase();
    return {};
  }
});
const getKnowledgeBaseEntries = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/kb/entries',
  options: {
    tags: ['access:ai_assistant']
  },
  params: t.type({
    query: t.type({
      query: t.string,
      sortBy: t.string,
      sortDirection: t.union([t.literal('asc'), t.literal('desc')])
    })
  }),
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    const {
      query,
      sortBy,
      sortDirection
    } = resources.params.query;
    return await client.getKnowledgeBaseEntries({
      query,
      sortBy,
      sortDirection
    });
  }
});
const saveKnowledgeBaseEntry = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/kb/entries/save',
  params: t.type({
    body: t.intersection([t.type({
      id: t.string,
      text: _ioTsUtils.nonEmptyStringRt
    }), t.partial({
      confidence: t.union([t.literal('low'), t.literal('medium'), t.literal('high')]),
      is_correction: _ioTsUtils.toBooleanRt,
      public: _ioTsUtils.toBooleanRt,
      labels: t.record(t.string, t.string),
      role: t.union([t.literal('assistant_summarization'), t.literal('user_entry'), t.literal('elastic')])
    })])
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    var _resources$params$bod, _resources$params$bod2, _resources$params$bod3, _resources$params$bod4, _ref;
    const client = await resources.service.getClient({
      request: resources.request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    const {
      id,
      text
    } = resources.params.body;
    return client.createKnowledgeBaseEntry({
      entry: {
        id,
        text,
        doc_id: id,
        confidence: (_resources$params$bod = resources.params.body.confidence) !== null && _resources$params$bod !== void 0 ? _resources$params$bod : 'high',
        is_correction: (_resources$params$bod2 = resources.params.body.is_correction) !== null && _resources$params$bod2 !== void 0 ? _resources$params$bod2 : false,
        public: (_resources$params$bod3 = resources.params.body.public) !== null && _resources$params$bod3 !== void 0 ? _resources$params$bod3 : true,
        labels: (_resources$params$bod4 = resources.params.body.labels) !== null && _resources$params$bod4 !== void 0 ? _resources$params$bod4 : {},
        role: (_ref = resources.params.body.role) !== null && _ref !== void 0 ? _ref : _types.KnowledgeBaseEntryRole.UserEntry
      }
    });
  }
});
const deleteKnowledgeBaseEntry = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'DELETE /internal/observability_ai_assistant/kb/entries/{entryId}',
  params: t.type({
    path: t.type({
      entryId: t.string
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.deleteKnowledgeBaseEntry(resources.params.path.entryId);
  }
});
const importKnowledgeBaseEntries = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/kb/entries/import',
  params: t.type({
    body: t.type({
      entries: t.array(t.type({
        id: t.string,
        text: _ioTsUtils.nonEmptyStringRt
      }))
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    const entries = resources.params.body.entries.map(entry => ({
      doc_id: entry.id,
      confidence: 'high',
      is_correction: false,
      public: true,
      labels: {},
      role: _types.KnowledgeBaseEntryRole.UserEntry,
      ...entry
    }));
    return await client.importKnowledgeBaseEntries({
      entries
    });
  }
});
const knowledgeBaseRoutes = exports.knowledgeBaseRoutes = {
  ...setupKnowledgeBase,
  ...getKnowledgeBaseStatus,
  ...getKnowledgeBaseEntries,
  ...importKnowledgeBaseEntries,
  ...saveKnowledgeBaseEntry,
  ...deleteKnowledgeBaseEntry
};