"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAIAssistantPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _saved_objects = require("@kbn/actions-plugin/server/constants/saved_objects");
var _rxjs = require("rxjs");
var _feature = require("../common/feature");
var _register_routes = require("./routes/register_routes");
var _service = require("./service");
var _lens = require("./service/knowledge_base_service/kb_docs/lens");
var _functions = require("./functions");
var _recall_ranking = require("./analytics/recall_ranking");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityAIAssistantPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "service", void 0);
    this.logger = context.logger.get();
  }
  setup(core, plugins) {
    plugins.features.registerKibanaFeature({
      id: _feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID,
      name: _i18n.i18n.translate('xpack.observabilityAiAssistant.featureRegistry.featureName', {
        defaultMessage: 'Observability AI Assistant'
      }),
      order: 8600,
      category: _server.DEFAULT_APP_CATEGORIES.observability,
      app: [_feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID, 'kibana'],
      catalogue: [_feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID],
      minimumLicense: 'enterprise',
      // see x-pack/plugins/features/common/feature_kibana_privileges.ts
      privileges: {
        all: {
          app: [_feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID, 'kibana'],
          api: [_feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID, 'ai_assistant'],
          catalogue: [_feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID],
          savedObject: {
            all: [_saved_objects.ACTION_SAVED_OBJECT_TYPE, _saved_objects.ACTION_TASK_PARAMS_SAVED_OBJECT_TYPE, _saved_objects.CONNECTOR_TOKEN_SAVED_OBJECT_TYPE],
            read: []
          },
          ui: ['show']
        },
        read: {
          disabled: true,
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        }
      }
    });
    const routeHandlerPlugins = (0, _lodash.mapValues)(plugins, (value, key) => {
      return {
        setup: value,
        start: () => core.getStartServices().then(services => {
          const [, pluginsStartContracts] = services;
          return pluginsStartContracts[key];
        })
      };
    });

    // Using once to make sure the same model ID is used during service init and Knowledge base setup
    const getModelId = (0, _lodash.once)(async () => {
      const defaultModelId = '.elser_model_2';
      const [_, pluginsStart] = await core.getStartServices();
      const license = await (0, _rxjs.firstValueFrom)(pluginsStart.licensing.license$);
      if (!license.hasAtLeast('enterprise')) {
        return defaultModelId;
      }
      try {
        // Wait for the ML plugin's dependency on the internal saved objects client to be ready
        const {
          ml
        } = await core.plugins.onSetup('ml');
        if (!ml.found) {
          throw new Error('Could not find ML plugin');
        }
        const elserModelDefinition = await ml.contract.trainedModelsProvider({}, {}) // request, savedObjectsClient (but we fake it to use the internal user)
        .getELSER();
        return elserModelDefinition.model_id;
      } catch (error) {
        this.logger.error(`Failed to resolve ELSER model definition: ${error}`);
        return defaultModelId;
      }
    });
    const service = this.service = new _service.ObservabilityAIAssistantService({
      logger: this.logger.get('service'),
      core,
      taskManager: plugins.taskManager,
      getModelId
    });
    service.register(_functions.registerFunctions);
    (0, _lens.addLensDocsToKb)({
      service,
      logger: this.logger.get('kb').get('lens')
    });
    (0, _register_routes.registerServerRoutes)({
      core,
      logger: this.logger,
      dependencies: {
        plugins: routeHandlerPlugins,
        service: this.service
      }
    });
    core.analytics.registerEventType(_recall_ranking.recallRankingEvent);
    return {
      service
    };
  }
  start() {
    return {
      service: this.service
    };
  }
}
exports.ObservabilityAIAssistantPlugin = ObservabilityAIAssistantPlugin;