"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "aiAssistantLogsIndexPattern", {
  enumerable: true,
  get: function () {
    return _common.aiAssistantLogsIndexPattern;
  }
});
Object.defineProperty(exports, "aiAssistantResponseLanguage", {
  enumerable: true,
  get: function () {
    return _common.aiAssistantResponseLanguage;
  }
});
Object.defineProperty(exports, "aiAssistantSimulatedFunctionCalling", {
  enumerable: true,
  get: function () {
    return _common.aiAssistantSimulatedFunctionCalling;
  }
});
exports.plugin = exports.config = void 0;
Object.defineProperty(exports, "streamIntoObservable", {
  enumerable: true,
  get: function () {
    return _stream_into_observable.streamIntoObservable;
  }
});
var _config = require("./config");
var _common = require("../common");
var _stream_into_observable = require("./service/util/stream_into_observable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const config = exports.config = {
  deprecations: ({
    unusedFromRoot
  }) => [unusedFromRoot('xpack.observability.aiAssistant.enabled', {
    level: 'warning'
  }), unusedFromRoot('xpack.observability.aiAssistant.provider.azureOpenAI.deploymentId', {
    level: 'warning'
  }), unusedFromRoot('xpack.observability.aiAssistant.provider.azureOpenAI.resourceName', {
    level: 'warning'
  }), unusedFromRoot('xpack.observability.aiAssistant.provider.azureOpenAI.apiKey', {
    level: 'warning'
  }), unusedFromRoot('xpack.observability.aiAssistant.provider.openAI.apiKey', {
    level: 'warning'
  }), unusedFromRoot('xpack.observability.aiAssistant.provider.openAI.model', {
    level: 'warning'
  })],
  exposeToBrowser: {},
  schema: _config.config
};
const plugin = async ctx => {
  const {
    ObservabilityAIAssistantPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new ObservabilityAIAssistantPlugin(ctx);
};
exports.plugin = plugin;