"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStorybookService = exports.createStorybookChatService = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _ = require(".");
var _builders = require("./utils/builders");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createStorybookChatService = () => ({
  sendAnalyticsEvent: () => {},
  chat: options => new _rxjs.Observable(),
  complete: options => new _rxjs.Observable(),
  getFunctions: () => [(0, _builders.buildFunctionElasticsearch)(), (0, _builders.buildFunctionServiceSummary)()],
  renderFunction: name => /*#__PURE__*/_react.default.createElement("div", null, _i18n.i18n.translate('xpack.observabilityAiAssistant.chatService.div.helloLabel', {
    defaultMessage: 'Hello'
  }), name),
  hasFunction: () => true,
  hasRenderFunction: () => true,
  getSystemMessage: () => ({
    '@timestamp': new Date().toISOString(),
    message: {
      role: _.MessageRole.System,
      content: 'System'
    }
  })
});
exports.createStorybookChatService = createStorybookChatService;
const createStorybookService = () => ({
  isEnabled: () => true,
  start: async () => {
    return createStorybookChatService();
  },
  callApi: {},
  register: () => {},
  setScreenContext: () => _lodash.noop,
  getScreenContexts: () => [],
  conversations: {
    openNewConversation: _lodash.noop,
    predefinedConversation$: new _rxjs.Observable()
  },
  navigate: async () => (0, _rxjs.of)()
});
exports.createStorybookService = createStorybookService;