"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservabilityAIAssistant = useObservabilityAIAssistant;
exports.useObservabilityAIAssistantOptional = useObservabilityAIAssistantOptional;
var _react = require("react");
var _observability_ai_assistant_provider = require("../context/observability_ai_assistant_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useObservabilityAIAssistantOptional() {
  const services = (0, _react.useContext)(_observability_ai_assistant_provider.ObservabilityAIAssistantContext);
  return services;
}
function useObservabilityAIAssistant() {
  const services = (0, _react.useContext)(_observability_ai_assistant_provider.ObservabilityAIAssistantContext);
  if (!services) {
    throw new Error('ObservabilityAIAssistantContext not set. Did you wrap your component in `<ObservabilityAIAssistantProvider/>`?');
  }
  return services;
}