"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.throwSerializedChatCompletionErrors = throwSerializedChatCompletionErrors;
var _rxjs = require("rxjs");
var _conversation_complete = require("../conversation_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function throwSerializedChatCompletionErrors() {
  return source$ => source$.pipe((0, _rxjs.tap)(event => {
    // de-serialise error
    if (event.type === _conversation_complete.StreamingChatResponseEventType.ChatCompletionError) {
      var _event$error$code;
      const code = (_event$error$code = event.error.code) !== null && _event$error$code !== void 0 ? _event$error$code : _conversation_complete.ChatCompletionErrorCode.InternalError;
      const message = event.error.message;
      const meta = event.error.meta;
      throw new _conversation_complete.ChatCompletionError(code, message, meta);
    }
  }), (0, _rxjs.filter)(event => event.type !== _conversation_complete.StreamingChatResponseEventType.ChatCompletionError));
}