"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emitWithConcatenatedMessage = emitWithConcatenatedMessage;
var _rxjs = require("rxjs");
var _without_token_count_events = require("./without_token_count_events");
var _conversation_complete = require("../conversation_complete");
var _concatenate_chat_completion_chunks = require("./concatenate_chat_completion_chunks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeWithEditedMessage(originalMessage, chunkEvent, callback) {
  return (0, _rxjs.from)((callback ? callback(originalMessage) : Promise.resolve(originalMessage)).then(message => {
    const next = {
      type: _conversation_complete.StreamingChatResponseEventType.MessageAdd,
      id: chunkEvent.id,
      message: {
        '@timestamp': new Date().toISOString(),
        ...message
      }
    };
    return next;
  }));
}
function emitWithConcatenatedMessage(callback) {
  return source$ => {
    const shared = source$.pipe((0, _rxjs.shareReplay)());
    const withoutTokenCount$ = shared.pipe((0, _without_token_count_events.withoutTokenCountEvents)());
    const response$ = (0, _rxjs.concat)(shared, shared.pipe((0, _without_token_count_events.withoutTokenCountEvents)(), (0, _concatenate_chat_completion_chunks.concatenateChatCompletionChunks)(), (0, _rxjs.last)(), (0, _rxjs.withLatestFrom)(withoutTokenCount$), (0, _rxjs.mergeMap)(([message, chunkEvent]) => {
      return mergeWithEditedMessage(message, chunkEvent, callback);
    })));
    return response$;
  };
}