"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUPPORTED_CONNECTOR_TYPES = exports.ObservabilityAIAssistantConnectorType = void 0;
exports.isSupportedConnectorType = isSupportedConnectorType;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ObservabilityAIAssistantConnectorType = exports.ObservabilityAIAssistantConnectorType = /*#__PURE__*/function (ObservabilityAIAssistantConnectorType) {
  ObservabilityAIAssistantConnectorType["Bedrock"] = ".bedrock";
  ObservabilityAIAssistantConnectorType["OpenAI"] = ".gen-ai";
  return ObservabilityAIAssistantConnectorType;
}({});
const SUPPORTED_CONNECTOR_TYPES = exports.SUPPORTED_CONNECTOR_TYPES = [ObservabilityAIAssistantConnectorType.OpenAI, ObservabilityAIAssistantConnectorType.Bedrock];
function isSupportedConnectorType(type) {
  return type === ObservabilityAIAssistantConnectorType.Bedrock || type === ObservabilityAIAssistantConnectorType.OpenAI;
}