"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UISettings = UISettings;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/observability-ai-assistant-plugin/public");
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _use_app_context = require("../../../hooks/use_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const settingsKeys = [_public2.aiAssistantLogsIndexPattern, _public2.aiAssistantResponseLanguage, _public2.aiAssistantSimulatedFunctionCalling];
function UISettings() {
  const {
    docLinks,
    settings,
    notifications
  } = (0, _use_app_context.useAppContext)();
  const {
    fields,
    handleFieldChange,
    unsavedChanges,
    saveAll,
    isSaving,
    cleanUnsavedChanges
  } = (0, _public.useEditableSettings)(settingsKeys);
  async function handleSave() {
    try {
      await saveAll();
      window.location.reload();
    } catch (e) {
      const error = e;
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.apmSettings.save.error', {
          defaultMessage: 'An error occurred while saving the settings'
        }),
        text: error.message
      });
    }
  }
  const hasInvalidChanges = Object.values(unsavedChanges).some(({
    isInvalid
  }) => isInvalid);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), settingsKeys.map(settingKey => {
    const field = fields[settingKey];
    if (!field) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
      key: settingKey,
      links: docLinks.links.management,
      showDanger: message => notifications.toasts.addDanger(message),
      validateChange: (key, value) => settings.client.validateValue(key, value)
    }, /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRow, {
      field: field,
      isSavingEnabled: true,
      onFieldChange: handleFieldChange,
      unsavedChange: unsavedChanges[settingKey]
    }));
  }), !(0, _lodash.isEmpty)(unsavedChanges) && /*#__PURE__*/_react.default.createElement(_public.BottomBarActions, {
    isLoading: isSaving,
    onDiscardChanges: cleanUnsavedChanges,
    onSave: handleSave,
    saveLabel: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.apmSettings.saveButton', {
      defaultMessage: 'Save changes'
    }),
    unsavedChangesCount: Object.keys(unsavedChanges).length,
    appTestSubj: "apm",
    areChangesInvalid: hasInvalidChanges
  }));
}