"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservabilityAIAssistantManagementRouter = useObservabilityAIAssistantManagementRouter;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _use_app_context = require("./use_app_context");
var _config = require("../routes/config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useObservabilityAIAssistantManagementRouter() {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    http
  } = (0, _use_app_context.useAppContext)();
  const link = (...args) => {
    // @ts-ignore
    return _config.aIAssistantManagementObservabilityRouter.link(...args);
  };
  return (0, _react.useMemo)(() => ({
    ..._config.aIAssistantManagementObservabilityRouter,
    push: (...args) => {
      const next = link(...args);
      history.push(next);
    },
    replace: (path, ...args) => {
      const next = link(path, ...args);
      history.replace(next);
    },
    link: (path, ...args) => {
      return http.basePath.prepend('/app/management/observabilityAiAssistantManagement' + link(path, ...args));
    }
  }), [http, history]);
}