"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateKnowledgeBaseEntry = useCreateKnowledgeBaseEntry;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _use_app_context = require("./use_app_context");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCreateKnowledgeBaseEntry() {
  const {
    notifications: {
      toasts
    },
    observabilityAIAssistant
  } = (0, _use_app_context.useAppContext)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const observabilityAIAssistantApi = observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service.callApi;
  return (0, _reactQuery.useMutation)([_constants.REACT_QUERY_KEYS.CREATE_KB_ENTRIES], ({
    entry
  }) => {
    if (!observabilityAIAssistantApi) {
      return Promise.reject('Error with observabilityAIAssistantApi: API not found.');
    }
    return observabilityAIAssistantApi === null || observabilityAIAssistantApi === void 0 ? void 0 : observabilityAIAssistantApi('POST /internal/observability_ai_assistant/kb/entries/save', {
      signal: null,
      params: {
        body: {
          ...entry,
          role: 'user_entry'
        }
      }
    });
  }, {
    onSuccess: (_data, {
      entry
    }) => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kb.addManualEntry.successNotification', {
        defaultMessage: 'Successfully created {name}',
        values: {
          name: entry.id
        }
      }));
      queryClient.invalidateQueries({
        queryKey: [_constants.REACT_QUERY_KEYS.GET_KB_ENTRIES],
        refetchType: 'all'
      });
    },
    onError: (error, {
      entry
    }) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kb.addManualEntry.errorNotification', {
          defaultMessage: 'Something went wrong while creating {name}',
          values: {
            name: entry.id
          }
        })
      });
    }
  });
}