"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.categorizeEntries = categorizeEntries;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function categorizeEntries({
  entries
}) {
  return entries.reduce((acc, entry) => {
    var _entry$labels$categor, _entry$labels;
    const categoryName = (_entry$labels$categor = (_entry$labels = entry.labels) === null || _entry$labels === void 0 ? void 0 : _entry$labels.category) !== null && _entry$labels$categor !== void 0 ? _entry$labels$categor : entry.id;
    const index = acc.findIndex(item => item.categoryName === categoryName);
    if (index > -1) {
      acc[index].entries.push(entry);
      return acc;
    } else {
      return acc.concat({
        categoryName,
        entries: [entry],
        '@timestamp': entry['@timestamp']
      });
    }
  }, []);
}