"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-ai-assistant-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const uiSettings = exports.uiSettings = {
  [_common.aiAssistantResponseLanguage]: {
    category: ['observability'],
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.userPreferencesLabel', {
      defaultMessage: 'Response language'
    }),
    value: _common.DEFAULT_LANGUAGE_OPTION.value,
    description: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.selectYourLanguageLabel', {
      defaultMessage: 'Select the language you wish the Assistant to use when generating responses.'
    }),
    // Argument of type 'Type<string>[]' is not assignable to parameter of type '[Type<string>]'.
    // @ts-expect-error
    schema: _configSchema.schema.oneOf(_common.LANGUAGE_OPTIONS.map(lang => _configSchema.schema.literal(lang.value))),
    type: 'select',
    options: _common.LANGUAGE_OPTIONS.map(lang => lang.value),
    optionLabels: _common.LANGUAGE_OPTIONS.reduce((acc, {
      value,
      label
    }) => ({
      ...acc,
      [value]: label
    }), {}),
    requiresPageReload: true
  },
  [_common.aiAssistantLogsIndexPattern]: {
    category: ['observability'],
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsTab.h3.logIndexPatternLabel', {
      defaultMessage: 'Logs index pattern'
    }),
    value: 'logs-*',
    description: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.logIndexPatternDescription', {
      defaultMessage: 'Index pattern used by the AI Assistant when querying for logs. Logs are categorised and used for root cause analysis'
    }),
    schema: _configSchema.schema.string(),
    type: 'string',
    requiresPageReload: true
  },
  [_common.aiAssistantSimulatedFunctionCalling]: {
    category: ['observability'],
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.simulatedFunctionCallingLabel', {
      defaultMessage: 'Simulate function calling'
    }),
    value: false,
    description: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.simulatedFunctionCallingDescription', {
      defaultMessage: '<em>[technical preview]</em> Use simulated function calling. Simulated function calling does not need API support for functions or tools, but it may decrease performance. Simulated function calling is currently always enabled for non-OpenAI connector, regardless of this setting.'
    }),
    schema: _configSchema.schema.boolean(),
    type: 'boolean',
    requiresPageReload: true
  }
};