"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateEsqlQuery = validateEsqlQuery;
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
var _esqlAst = require("@kbn/esql-ast");
var _fieldTypes = require("@kbn/field-types");
var _correct_common_esql_mistakes = require("./correct_common_esql_mistakes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function validateEsqlQuery({
  query,
  client
}) {
  const {
    errors
  } = await (0, _esqlValidationAutocomplete.validateQuery)(query, _esqlAst.getAstAndSyntaxErrors, {
    // setting this to true, we don't want to validate the index / fields existence
    ignoreOnMissingCallbacks: true
  });
  const asCommands = (0, _correct_common_esql_mistakes.splitIntoCommands)(query);
  const errorMessages = errors === null || errors === void 0 ? void 0 : errors.map(error => {
    if ('location' in error) {
      const commandsUntilEndOfError = (0, _correct_common_esql_mistakes.splitIntoCommands)(query.substring(0, error.location.max));
      const lastCompleteCommand = asCommands[commandsUntilEndOfError.length - 1];
      if (lastCompleteCommand) {
        return `Error in ${lastCompleteCommand.command}\n: ${error.text}`;
      }
    }
    return 'text' in error ? error.text : error.message;
  });

  // With limit 0 I get only the columns, it is much more performant
  const performantQuery = `${query} | limit 0`;
  return client.transport.request({
    method: 'POST',
    path: '_query',
    body: {
      query: performantQuery
    }
  }).then(res => {
    var _esqlResponse$columns, _esqlResponse$columns2;
    const esqlResponse = res;
    const columns = (_esqlResponse$columns = (_esqlResponse$columns2 = esqlResponse.columns) === null || _esqlResponse$columns2 === void 0 ? void 0 : _esqlResponse$columns2.map(({
      name,
      type
    }) => ({
      id: name,
      name,
      meta: {
        type: (0, _fieldTypes.esFieldTypeToKibanaFieldType)(type)
      }
    }))) !== null && _esqlResponse$columns !== void 0 ? _esqlResponse$columns : [];
    return {
      columns
    };
  }).catch(error => {
    return {
      error,
      ...(errorMessages.length ? {
        errorMessages
      } : {})
    };
  });
}