"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFunctions = void 0;
var _alerts = require("./alerts");
var _query = require("./query");
var _lens = require("./lens");
var _visualize_esql = require("./visualize_esql");
var _changes = require("./changes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerFunctions = async registrationParameters => {
  (0, _lens.registerLensFunction)(registrationParameters);
  (0, _query.registerQueryFunction)(registrationParameters);
  (0, _visualize_esql.registerVisualizeESQLFunction)(registrationParameters);
  (0, _alerts.registerAlertsFunction)(registrationParameters);
  (0, _changes.registerChangesFunction)(registrationParameters);
};
exports.registerFunctions = registerFunctions;