"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaReactStorybookDecorator = KibanaReactStorybookDecorator;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _public2 = require("@kbn/observability-ai-assistant-plugin/public");
var _observability_ai_assistant_app_service_provider = require("../context/observability_ai_assistant_app_service_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mockService = {
  ...(0, _public2.createStorybookService)()
};
const mockChatService = (0, _public2.createStorybookChatService)();
function KibanaReactStorybookDecorator(Story) {
  const ObservabilityAIAssistantChatServiceContext = /*#__PURE__*/_react.default.createContext(mockChatService);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      triggersActionsUi: {
        getAddRuleFlyout: {}
      },
      uiSettings: {
        get: setting => {
          if (setting === 'dateFormat') {
            return 'MMM D, YYYY HH:mm';
          }
        }
      },
      observabilityAIAssistant: {
        ObservabilityAIAssistantChatServiceContext
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_observability_ai_assistant_app_service_provider.ObservabilityAIAssistantAppServiceProvider, {
    value: mockService
  }, /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantChatServiceContext.Provider, {
    value: mockChatService
  }, /*#__PURE__*/_react.default.createElement(Story, null))));
}