"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSimulatedFunctionCalling = useSimulatedFunctionCalling;
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSimulatedFunctionCalling() {
  const {
    services: {
      uiSettings
    }
  } = (0, _use_kibana.useKibana)();
  const simulatedFunctionCallingEnabled = uiSettings.get(_public.aiAssistantSimulatedFunctionCalling, false);
  return {
    simulatedFunctionCallingEnabled
  };
}