"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConversationList = useConversationList;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _use_kibana = require("./use_kibana");
var _use_observability_ai_assistant_app_service = require("./use_observability_ai_assistant_app_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useConversationList() {
  const service = (0, _use_observability_ai_assistant_app_service.useObservabilityAIAssistantAppService)();
  const [isUpdatingList, setIsUpdatingList] = (0, _react.useState)(false);
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const conversations = (0, _public.useAbortableAsync)(({
    signal
  }) => {
    setIsUpdatingList(true);
    return service.callApi('POST /internal/observability_ai_assistant/conversations', {
      signal
    });
  }, [service]);
  (0, _react.useEffect)(() => {
    setIsUpdatingList(conversations.loading);
  }, [conversations.loading]);
  const handleDeleteConversation = async id => {
    setIsUpdatingList(true);
    try {
      await service.callApi('DELETE /internal/observability_ai_assistant/conversation/{conversationId}', {
        params: {
          path: {
            conversationId: id
          }
        },
        signal: null
      });
      conversations.refresh();
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistant.flyout.failedToDeleteConversation', {
          defaultMessage: 'Could not delete conversation'
        })
      });
    }
  };
  return {
    deleteConversation: id => {
      setIsUpdatingList(true);
      return handleDeleteConversation(id).finally(() => {
        setIsUpdatingList(false);
      });
    },
    conversations,
    isLoading: conversations.loading || isUpdatingList
  };
}