"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConversationKey = useConversationKey;
var _react = require("react");
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Regenerate the key only when the id changes, except after
// creating the conversation. Ideally this happens by adding
// state to the current route, but I'm not keen on adding
// the concept of state to the router, due to a mismatch
// between router.link() and router.push(). So, this is a
// pretty gross workaround for persisting a key under some
// conditions.

function useConversationKey(conversationId) {
  const keyRef = (0, _react.useRef)((0, _uuid.v4)());
  const conversationIdRef = (0, _react.useRef)(conversationId);
  if (conversationIdRef.current !== conversationId) {
    keyRef.current = (0, _uuid.v4)();
  }
  conversationIdRef.current = conversationId;
  return {
    updateConversationIdInPlace: nextConversationId => {
      conversationIdRef.current = nextConversationId;
    },
    key: keyRef.current
  };
}