"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeESQL = VisualizeESQL;
exports.registerVisualizeQueryRenderFunction = registerVisualizeQueryRenderFunction;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _esqlUtils = require("@kbn/esql-utils");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _visualizationUtils = require("@kbn/visualization-utils");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _uuid = require("uuid");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var ChartType = /*#__PURE__*/function (ChartType) {
  ChartType["XY"] = "XY";
  ChartType["Bar"] = "Bar";
  ChartType["Line"] = "Line";
  ChartType["Area"] = "Area";
  ChartType["Donut"] = "Donut";
  ChartType["Heatmap"] = "Heat map";
  ChartType["Treemap"] = "Treemap";
  ChartType["Tagcloud"] = "Tag cloud";
  ChartType["Waffle"] = "Waffle";
  ChartType["Table"] = "Table";
  return ChartType;
}(ChartType || {});
function generateId() {
  return (0, _uuid.v4)();
}
function VisualizeESQL({
  lens,
  dataViews,
  uiActions,
  columns,
  query,
  onActionClick,
  userOverrides,
  preferredChartType,
  ObservabilityAIAssistantMultipaneFlyoutContext,
  errorMessages
}) {
  // fetch the pattern from the query
  const indexPattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)(query);
  const lensHelpersAsync = (0, _useAsync.default)(() => {
    return lens.stateHelperApi();
  }, [lens]);
  const dataViewAsync = (0, _useAsync.default)(() => {
    return (0, _esqlUtils.getESQLAdHocDataview)(indexPattern, dataViews);
  }, [indexPattern]);
  const chatFlyoutSecondSlotHandler = (0, _react.useContext)(ObservabilityAIAssistantMultipaneFlyoutContext);
  const [isSaveModalOpen, setIsSaveModalOpen] = (0, _react.useState)(false);
  const [lensInput, setLensInput] = (0, _react.useState)(userOverrides);
  const [lensLoadEvent, setLensLoadEvent] = (0, _react.useState)(null);
  const onLoad = (0, _react.useCallback)((isLoading, adapters, lensEmbeddableOutput$) => {
    var _adapters$tables;
    const adapterTables = adapters === null || adapters === void 0 ? void 0 : (_adapters$tables = adapters.tables) === null || _adapters$tables === void 0 ? void 0 : _adapters$tables.tables;
    if (adapterTables && !isLoading) {
      setLensLoadEvent({
        adapters,
        embeddableOutput$: lensEmbeddableOutput$
      });
    }
  }, []);

  // initialization
  (0, _react.useEffect)(() => {
    if (lensHelpersAsync.value && dataViewAsync.value && !lensInput) {
      var _dataViewAsync$value;
      const context = {
        dataViewSpec: (_dataViewAsync$value = dataViewAsync.value) === null || _dataViewAsync$value === void 0 ? void 0 : _dataViewAsync$value.toSpec(),
        fieldName: '',
        textBasedColumns: columns,
        query: {
          esql: query
        }
      };
      const chartSuggestions = lensHelpersAsync.value.suggestions(context, dataViewAsync.value, [], preferredChartType);
      if (chartSuggestions !== null && chartSuggestions !== void 0 && chartSuggestions.length) {
        const [suggestion] = chartSuggestions;
        const attrs = (0, _visualizationUtils.getLensAttributesFromSuggestion)({
          filters: [],
          query: {
            esql: query
          },
          suggestion,
          dataView: dataViewAsync.value
        });
        const lensEmbeddableInput = {
          attributes: attrs,
          id: generateId()
        };
        setLensInput(lensEmbeddableInput);
      }
    }
  }, [columns, dataViewAsync.value, lensHelpersAsync.value, lensInput, query, preferredChartType]);

  // trigger options to open the inline editing flyout correctly
  const triggerOptions = (0, _react.useMemo)(() => {
    if (lensInput !== null && lensInput !== void 0 && lensInput.attributes) {
      return {
        attributes: lensInput === null || lensInput === void 0 ? void 0 : lensInput.attributes,
        lensEvent: lensLoadEvent !== null && lensLoadEvent !== void 0 ? lensLoadEvent : {
          adapters: {}
        },
        onUpdate: newAttributes => {
          if (lensInput) {
            const newInput = {
              ...lensInput,
              attributes: newAttributes
            };
            setLensInput(newInput);
          }
        },
        onApply: newAttributes => {
          var _chatFlyoutSecondSlot;
          const newInput = {
            ...lensInput,
            attributes: newAttributes
          };
          onActionClick({
            type: _public.ChatActionClickType.updateVisualization,
            userOverrides: newInput,
            query
          });
          chatFlyoutSecondSlotHandler === null || chatFlyoutSecondSlotHandler === void 0 ? void 0 : (_chatFlyoutSecondSlot = chatFlyoutSecondSlotHandler.setVisibility) === null || _chatFlyoutSecondSlot === void 0 ? void 0 : _chatFlyoutSecondSlot.call(chatFlyoutSecondSlotHandler, false);
          if (chatFlyoutSecondSlotHandler !== null && chatFlyoutSecondSlotHandler !== void 0 && chatFlyoutSecondSlotHandler.container) {
            _reactDom.default.unmountComponentAtNode(chatFlyoutSecondSlotHandler.container);
          }
        },
        onCancel: () => {
          var _chatFlyoutSecondSlot2;
          onActionClick({
            type: _public.ChatActionClickType.updateVisualization,
            userOverrides: lensInput,
            query
          });
          chatFlyoutSecondSlotHandler === null || chatFlyoutSecondSlotHandler === void 0 ? void 0 : (_chatFlyoutSecondSlot2 = chatFlyoutSecondSlotHandler.setVisibility) === null || _chatFlyoutSecondSlot2 === void 0 ? void 0 : _chatFlyoutSecondSlot2.call(chatFlyoutSecondSlotHandler, false);
          if (chatFlyoutSecondSlotHandler !== null && chatFlyoutSecondSlotHandler !== void 0 && chatFlyoutSecondSlotHandler.container) {
            _reactDom.default.unmountComponentAtNode(chatFlyoutSecondSlotHandler.container);
          }
        },
        container: chatFlyoutSecondSlotHandler === null || chatFlyoutSecondSlotHandler === void 0 ? void 0 : chatFlyoutSecondSlotHandler.container
      };
    }
  }, [chatFlyoutSecondSlotHandler, lensInput, lensLoadEvent, onActionClick, query]);
  if (!lensHelpersAsync.value || !dataViewAsync.value || !lensInput) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, Boolean(errorMessages === null || errorMessages === void 0 ? void 0 : errorMessages.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.errorMessage', {
    defaultMessage: 'There were some errors in the generated query'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "observabilityAiAssistantErrorsList"
  }, errorMessages === null || errorMessages === void 0 ? void 0 : errorMessages.map((error, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "error",
      color: "danger",
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, error)));
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.edit', {
      defaultMessage: 'Edit visualization'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "pencil",
    onClick: () => {
      var _chatFlyoutSecondSlot3;
      chatFlyoutSecondSlotHandler === null || chatFlyoutSecondSlotHandler === void 0 ? void 0 : (_chatFlyoutSecondSlot3 = chatFlyoutSecondSlotHandler.setVisibility) === null || _chatFlyoutSecondSlot3 === void 0 ? void 0 : _chatFlyoutSecondSlot3.call(chatFlyoutSecondSlotHandler, true);
      if (triggerOptions) {
        uiActions.getTrigger('IN_APP_EMBEDDABLE_EDIT_TRIGGER').exec(triggerOptions);
      }
    },
    "data-test-subj": "observabilityAiAssistantLensESQLEditButton",
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.edit', {
      defaultMessage: 'Edit visualization'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.save', {
      defaultMessage: 'Save visualization'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "save",
    onClick: () => setIsSaveModalOpen(true),
    "data-test-subj": "observabilityAiAssistantLensESQLSaveButton",
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.lensESQLFunction.save', {
      defaultMessage: 'Save visualization'
    })
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "observabilityAiAssistantESQLLensChart"
  }, /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, (0, _extends2.default)({}, lensInput, {
    style: {
      height: 240
    },
    onLoad: onLoad
  })))), isSaveModalOpen ? /*#__PURE__*/_react.default.createElement(lens.SaveModalComponent, {
    initialInput: lensInput,
    onClose: () => {
      setIsSaveModalOpen(() => false);
    }
    // For now, we don't want to allow saving ESQL charts to the library
    ,
    isSaveable: false
  }) : null);
}
function registerVisualizeQueryRenderFunction({
  registerRenderFunction,
  pluginsStart
}) {
  registerRenderFunction('visualize_query', ({
    arguments: {
      query,
      userOverrides,
      intention
    },
    response,
    onActionClick
  }) => {
    const typedResponse = response;
    const columns = 'data' in typedResponse ? typedResponse.data.columns : typedResponse.content;
    const errorMessages = 'content' in typedResponse && 'errorMessages' in typedResponse.content ? typedResponse.content.errorMessages : [];
    if ('data' in typedResponse && 'userOverrides' in typedResponse.data) {
      userOverrides = typedResponse.data.userOverrides;
    }
    let preferredChartType;
    switch (intention) {
      case _public.VisualizeESQLUserIntention.executeAndReturnResults:
      case _public.VisualizeESQLUserIntention.generateQueryOnly:
      case _public.VisualizeESQLUserIntention.visualizeAuto:
        break;
      case _public.VisualizeESQLUserIntention.visualizeBar:
        preferredChartType = ChartType.Bar;
        break;
      case _public.VisualizeESQLUserIntention.visualizeDonut:
        preferredChartType = ChartType.Donut;
        break;
      case _public.VisualizeESQLUserIntention.visualizeHeatmap:
        preferredChartType = ChartType.Heatmap;
        break;
      case _public.VisualizeESQLUserIntention.visualizeLine:
        preferredChartType = ChartType.Line;
        break;
      case _public.VisualizeESQLUserIntention.visualizeArea:
        preferredChartType = ChartType.Area;
        break;
      case _public.VisualizeESQLUserIntention.visualizeTable:
        preferredChartType = ChartType.Table;
        break;
      case _public.VisualizeESQLUserIntention.visualizeTagcloud:
        preferredChartType = ChartType.Tagcloud;
        break;
      case _public.VisualizeESQLUserIntention.visualizeTreemap:
        preferredChartType = ChartType.Treemap;
        break;
      case _public.VisualizeESQLUserIntention.visualizeWaffle:
        preferredChartType = ChartType.Waffle;
        break;
      case _public.VisualizeESQLUserIntention.visualizeXy:
        preferredChartType = ChartType.XY;
        break;
    }
    const trimmedQuery = query.trim();
    return /*#__PURE__*/_react.default.createElement(VisualizeESQL, {
      ObservabilityAIAssistantMultipaneFlyoutContext: pluginsStart.observabilityAIAssistant.ObservabilityAIAssistantMultipaneFlyoutContext,
      lens: pluginsStart.lens,
      dataViews: pluginsStart.dataViews,
      uiActions: pluginsStart.uiActions,
      columns: columns,
      query: trimmedQuery,
      onActionClick: onActionClick,
      userOverrides: userOverrides,
      preferredChartType: preferredChartType,
      errorMessages: errorMessages
    });
  });
}