"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromptEditorFunction = PromptEditorFunction;
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _css = require("@emotion/css");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _use_json_editor_model = require("../../hooks/use_json_editor_model");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const functionNameClassName = (0, _css.css)`
  display: inline-block;
`;
function PromptEditorFunction({
  functionName,
  functionPayload,
  onChange,
  onFocus,
  onBlur
}) {
  var _editorRef$current;
  const editorRef = (0, _react.useRef)(null);
  const [functionEditorLineCount, setFunctionEditorLineCount] = (0, _react.useState)(0);
  const previousPayload = (0, _usePrevious.default)(functionPayload);
  const {
    model,
    initialJsonString
  } = (0, _use_json_editor_model.useJsonEditorModel)({
    functionName,
    initialJson: functionPayload
  });
  const handleChangePayload = args => {
    recalculateLineCount();
    onChange({
      role: _public.MessageRole.Assistant,
      content: '',
      function_call: {
        name: functionName,
        trigger: _public.MessageRole.User,
        arguments: args
      }
    });
  };
  const recalculateLineCount = (0, _react.useCallback)(() => {
    const newLineCount = (model === null || model === void 0 ? void 0 : model.getLineCount()) || 0;
    if (newLineCount !== functionEditorLineCount) {
      setFunctionEditorLineCount(newLineCount + 1);
    }
  }, [functionEditorLineCount, model]);
  (0, _react.useEffect)(() => {
    recalculateLineCount();
  }, [model, recalculateLineCount]);
  (0, _react.useEffect)(() => {
    if (previousPayload === undefined && initialJsonString) {
      onChange({
        role: _public.MessageRole.Assistant,
        content: '',
        function_call: {
          name: functionName,
          trigger: _public.MessageRole.User,
          arguments: initialJsonString
        }
      });
    }
  }, [functionName, functionPayload, initialJsonString, onChange, previousPayload]);
  (_editorRef$current = editorRef.current) === null || _editorRef$current === void 0 ? void 0 : _editorRef$current.onDidBlurEditorWidget(() => {
    onBlur();
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    className: functionNameClassName
  }, functionName), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatPromptEditor.codeEditor.payloadEditorLabel', {
      defaultMessage: 'payloadEditor'
    }),
    "data-test-subj": "observabilityAiAssistantChatPromptEditorCodeEditor",
    editorDidMount: editor => {
      editorRef.current = editor;
      editor.focus();
      onFocus();
    },
    fullWidth: true,
    height: '180px',
    isCopyable: true,
    languageId: "json",
    languageConfiguration: {
      autoClosingPairs: [{
        open: '{',
        close: '}'
      }]
    },
    options: {
      accessibilitySupport: 'off',
      acceptSuggestionOnEnter: 'on',
      automaticLayout: true,
      autoClosingQuotes: 'always',
      autoIndent: 'full',
      contextmenu: true,
      fontSize: 12,
      formatOnPaste: true,
      formatOnType: true,
      inlayHints: {
        enabled: 'on'
      },
      lineNumbers: 'on',
      minimap: {
        enabled: false
      },
      model,
      overviewRulerBorder: false,
      quickSuggestions: true,
      scrollbar: {
        alwaysConsumeMouseWheel: false
      },
      scrollBeyondLastLine: false,
      suggestOnTriggerCharacters: true,
      tabSize: 2,
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    transparentBackground: true,
    value: functionPayload || '',
    onChange: handleChangePayload
  }));
}