"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromptEditor = PromptEditor;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _function_list_popover = require("../chat/function_list_popover");
var _prompt_editor_function = require("./prompt_editor_function");
var _prompt_editor_natural_language = require("./prompt_editor_natural_language");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PromptEditor({
  disabled,
  hidden,
  loading,
  initialRole,
  initialFunctionCall,
  initialContent,
  onChangeHeight,
  onSendTelemetry,
  onSubmit
}) {
  var _innerMessage$functio3, _innerMessage$functio4, _innerMessage$functio5, _innerMessage$functio6, _innerMessage$functio7;
  const containerRef = (0, _react.useRef)(null);
  const [mode, setMode] = (0, _react.useState)(initialFunctionCall !== null && initialFunctionCall !== void 0 && initialFunctionCall.name ? 'function' : 'prompt');
  const [hasFocus, setHasFocus] = (0, _react.useState)(false);
  const initialInnerMessage = initialRole ? {
    role: initialRole,
    content: initialContent !== null && initialContent !== void 0 ? initialContent : '',
    ...(initialFunctionCall ? {
      function_call: initialFunctionCall
    } : {})
  } : undefined;
  const [innerMessage, setInnerMessage] = (0, _react.useState)(initialInnerMessage);
  const invalid = (0, _react.useMemo)(() => {
    var _innerMessage$functio, _innerMessage$functio2;
    let isInvalid = false;
    if (innerMessage !== null && innerMessage !== void 0 && (_innerMessage$functio = innerMessage.function_call) !== null && _innerMessage$functio !== void 0 && _innerMessage$functio.name && innerMessage !== null && innerMessage !== void 0 && (_innerMessage$functio2 = innerMessage.function_call) !== null && _innerMessage$functio2 !== void 0 && _innerMessage$functio2.arguments) {
      try {
        JSON.parse(innerMessage.function_call.arguments);
      } catch (e) {
        isInvalid = true;
      }
      return isInvalid;
    }
  }, [innerMessage === null || innerMessage === void 0 ? void 0 : (_innerMessage$functio3 = innerMessage.function_call) === null || _innerMessage$functio3 === void 0 ? void 0 : _innerMessage$functio3.arguments, innerMessage === null || innerMessage === void 0 ? void 0 : (_innerMessage$functio4 = innerMessage.function_call) === null || _innerMessage$functio4 === void 0 ? void 0 : _innerMessage$functio4.name]);
  const handleChangeMessageInner = newInnerMessage => {
    setInnerMessage(newInnerMessage);
  };
  const handleSelectFunction = func => {
    if (func) {
      setMode('function');
      setInnerMessage({
        function_call: {
          name: func,
          trigger: _public.MessageRole.Assistant
        },
        role: _public.MessageRole.User
      });
      onChangeHeight(200);
      return;
    }
    setMode('prompt');
    setInnerMessage(undefined);
    if (containerRef.current) {
      onChangeHeight(containerRef.current.clientHeight);
    }
  };
  const handleSubmit = (0, _react.useCallback)(async () => {
    if (loading || !innerMessage) {
      return;
    }
    const oldMessage = innerMessage;
    try {
      const message = {
        '@timestamp': new Date().toISOString(),
        message: innerMessage
      };
      onSubmit(message);
      setInnerMessage(undefined);
      setMode('prompt');
      onSendTelemetry({
        type: _public.ObservabilityAIAssistantTelemetryEventType.UserSentPromptInChat,
        payload: message
      });
    } catch (_) {
      var _oldMessage$function_;
      setInnerMessage(oldMessage);
      setMode((_oldMessage$function_ = oldMessage.function_call) !== null && _oldMessage$function_ !== void 0 && _oldMessage$function_.name ? 'function' : 'prompt');
    }
  }, [innerMessage, loading, onSendTelemetry, onSubmit]);

  // Submit on Enter
  (0, _react.useEffect)(() => {
    const keyboardListener = event => {
      if (innerMessage && !disabled && !invalid && hasFocus) {
        if (!event.shiftKey && event.key === _eui.keys.ENTER) {
          event.preventDefault();
          handleSubmit();
        }
      }
    };
    window.addEventListener('keypress', keyboardListener);
    return () => {
      window.removeEventListener('keypress', keyboardListener);
    };
  }, [disabled, handleSubmit, hasFocus, innerMessage, invalid]);
  (0, _react.useEffect)(() => {
    if (hidden) {
      onChangeHeight(0);
    } else if (containerRef.current) {
      onChangeHeight(containerRef.current.clientHeight);
    }
  }, [hidden, onChangeHeight]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    ref: containerRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_function_list_popover.FunctionListPopover, {
    mode: mode,
    selectedFunctionName: innerMessage === null || innerMessage === void 0 ? void 0 : (_innerMessage$functio5 = innerMessage.function_call) === null || _innerMessage$functio5 === void 0 ? void 0 : _innerMessage$functio5.name,
    onSelectFunction: handleSelectFunction,
    disabled: loading || disabled
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, mode === 'function' && innerMessage !== null && innerMessage !== void 0 && (_innerMessage$functio6 = innerMessage.function_call) !== null && _innerMessage$functio6 !== void 0 && _innerMessage$functio6.name ? /*#__PURE__*/_react.default.createElement(_prompt_editor_function.PromptEditorFunction, {
    functionName: innerMessage.function_call.name,
    functionPayload: innerMessage.function_call.arguments,
    onChange: handleChangeMessageInner,
    onFocus: () => setHasFocus(true),
    onBlur: () => setHasFocus(false)
  }) : /*#__PURE__*/_react.default.createElement(_prompt_editor_natural_language.PromptEditorNaturalLanguage, {
    disabled: disabled,
    prompt: innerMessage === null || innerMessage === void 0 ? void 0 : innerMessage.content,
    onChange: handleChangeMessageInner,
    onChangeHeight: onChangeHeight,
    onFocus: () => setHasFocus(true),
    onBlur: () => setHasFocus(false)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "observabilityAiAssistantChatPromptEditorButtonIcon",
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatPromptEditor.euiButtonIcon.submitLabel', {
      defaultMessage: 'Submit'
    }),
    disabled: loading || disabled || invalid,
    display: mode === 'function' ? innerMessage !== null && innerMessage !== void 0 && (_innerMessage$functio7 = innerMessage.function_call) !== null && _innerMessage$functio7 !== void 0 && _innerMessage$functio7.name ? 'fill' : 'base' : innerMessage !== null && innerMessage !== void 0 && innerMessage.content ? 'fill' : 'base',
    iconType: "kqlFunction",
    isLoading: loading,
    size: "m",
    onClick: handleSubmit
  })));
}