"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAIAssistantPageTemplate = ObservabilityAIAssistantPageTemplate;
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pageSectionContentClassName = (0, _css.css)`
  width: 100%;
  display: flex;
  flex-grow: 1;
  padding-top: 0;
  padding-bottom: 0;
  max-block-size: calc(100vh - 96px);
`;
function ObservabilityAIAssistantPageTemplate({
  children
}) {
  const {
    services: {
      plugins: {
        start: {
          observabilityShared
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const PageTemplate = observabilityShared.navigation.PageTemplate;
  return /*#__PURE__*/_react.default.createElement(PageTemplate, {
    pageSectionProps: {
      alignment: 'horizontalCenter',
      restrictWidth: true,
      contentProps: {
        className: pageSectionContentClassName
      },
      paddingSize: 'none'
    }
  }, children);
}