"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavControl = NavControl;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _uuid = require("uuid");
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _use_observability_ai_assistant_app_service = require("../../hooks/use_observability_ai_assistant_app_service");
var _chat_flyout = require("../chat/chat_flyout");
var _use_kibana = require("../../hooks/use_kibana");
var _is_nav_control_visible = require("../../hooks/is_nav_control_visible");
var _use_theme = require("../../hooks/use_theme");
var _use_nav_control_screen_context = require("../../hooks/use_nav_control_screen_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NavControl({}) {
  var _useObservable;
  const service = (0, _use_observability_ai_assistant_app_service.useObservabilityAIAssistantAppService)();
  const {
    services: {
      notifications,
      plugins: {
        start: {
          observabilityAIAssistant: {
            ObservabilityAIAssistantChatServiceContext
          }
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const [hasBeenOpened, setHasBeenOpened] = (0, _react.useState)(false);
  (0, _use_nav_control_screen_context.useNavControlScreenContext)();
  const chatService = (0, _public.useAbortableAsync)(({
    signal
  }) => {
    return hasBeenOpened ? service.start({
      signal
    }).catch(error => {
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistant.navControl.initFailureErrorTitle', {
          defaultMessage: 'Failed to initialize Observability AI Assistant'
        })
      });
      setHasBeenOpened(false);
      setIsOpen(false);
      throw error;
    }) : undefined;
  }, [service, hasBeenOpened]);
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const keyRef = (0, _react.useRef)((0, _uuid.v4)());
  const {
    isVisible
  } = (0, _is_nav_control_visible.useIsNavControlVisible)();
  (0, _react.useEffect)(() => {
    const conversationSubscription = service.conversations.predefinedConversation$.subscribe(() => {
      setHasBeenOpened(true);
      setIsOpen(true);
    });
    return () => {
      conversationSubscription.unsubscribe();
    };
  }, [service.conversations.predefinedConversation$]);
  const {
    messages,
    title
  } = (_useObservable = (0, _useObservable2.default)(service.conversations.predefinedConversation$)) !== null && _useObservable !== void 0 ? _useObservable : {
    messages: [],
    title: undefined
  };
  const theme = (0, _use_theme.useTheme)();
  const buttonCss = (0, _react2.css)`
    padding: 0px 8px;

    svg path {
      fill: ${theme.colors.darkestShade};
    }
  `;
  if (!isVisible) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.navControl.euiButton.openObservabilityAIAssistantLabel', {
      defaultMessage: 'Open Observability AI Assistant chat'
    }),
    "data-test-subj": "observabilityAiAssistantAppNavControlButton",
    css: buttonCss,
    onClick: () => {
      service.conversations.openNewConversation({
        messages: []
      });
    },
    color: "primary",
    size: "s",
    fullWidth: false,
    minWidth: 0
  }, chatService.loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : /*#__PURE__*/_react.default.createElement(_public.AssistantAvatar, {
    size: "xs"
  })), chatService.value ? /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantChatServiceContext.Provider, {
    value: chatService.value
  }, /*#__PURE__*/_react.default.createElement(_chat_flyout.ChatFlyout, {
    key: keyRef.current,
    isOpen: isOpen,
    initialMessages: messages,
    initialTitle: title !== null && title !== void 0 ? title : '',
    onClose: () => {
      setIsOpen(false);
    }
  })) : undefined);
}