"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StarterPrompts = StarterPrompts;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _lodash = require("lodash");
var _use_observability_ai_assistant_app_service = require("../../hooks/use_observability_ai_assistant_app_service");
var _use_genai_connectors = require("../../hooks/use_genai_connectors");
var _non_nullable = require("../../utils/non_nullable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const starterPromptClassName = (0, _css.css)`
  max-width: 50%;
  min-width: calc(50% - 8px);
`;
const starterPromptInnerClassName = (0, _css.css)`
  text-align: center !important;
`;
function StarterPrompts({
  onSelectPrompt
}) {
  const service = (0, _use_observability_ai_assistant_app_service.useObservabilityAIAssistantAppService)();
  const {
    connectors
  } = (0, _use_genai_connectors.useGenAIConnectors)();
  if (!connectors || connectors.length === 0) {
    return null;
  }
  const contexts = service.getScreenContexts();
  const starterPrompts = (0, _lodash.uniq)([...contexts].reverse().flatMap(context => context.starterPrompts).filter(_non_nullable.nonNullable).slice(0, 4));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    wrap: true
  }, starterPrompts.map(({
    prompt,
    title,
    icon
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: prompt,
    className: starterPromptClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    hasBorder: true,
    onClick: () => onSelectPrompt(prompt),
    className: starterPromptInnerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, prompt)))));
}